import { Marker, Popup } from "react-leaflet"

import { useCurrentLocation } from "../../hooks/use-current-location"

export function CurrentLocationMarker() {
  const { position } = useCurrentLocation()

  if (!position) {
    return undefined
  }

  return (
    <>
      <Marker position={position}>
        <Popup>Simple css popup</Popup>
      </Marker>
    </>
  )
}
